Attribute VB_Name = "Hash_Func"
'Do not modify this file!
'This is part of BNHash functionality and could possibly be updated. If you don't want to lose anywork
'then it's advised that you create your own module.

Option Explicit

Public Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (ByRef Destination As Any, ByRef Source As Any, ByVal numbytes As Long)
Public Declare Function GetTickCount Lib "kernel32.dll" () As Long
Private Declare Function GetCurrentProcess Lib "kernel32" () As Long
Private Declare Function EmptyWorkingSet Lib "psapi.dll" (ByVal hProcess As Long) As Long
Private Declare Function SetProcessWorkingSetSize Lib "kernel32" (ByVal hProcess As Long, ByVal dwMinimumWorkingSetSize As Long _
                                                                , ByVal dwMaximumWorkingSetSize As Long) As Long
Private Declare Function setsockopt Lib "wsock32.dll" (ByVal s As Long, ByVal level As Long, ByVal optname As Long, ByRef optval As Long, ByVal optlen As Long) As Long

Public Sub SpeedSocket(ByVal SocketHandle As Long)
    Call setsockopt(SocketHandle, 6, &H1&, 1, 4)
    'Allows the socket to opreate without delay
End Sub

Public Sub FreeMemory()
ews_memory
spw_memory
End Sub
Public Function ews_memory() As Long:   ews_memory = EmptyWorkingSet(GetCurrentProcess):                  End Function
Public Function spw_memory() As Long:   spw_memory = SetProcessWorkingSetSize(GetCurrentProcess, -1, -1): End Function

Public Function DebugOutput(ByVal sIn As String) As String
     Dim X1 As Long, Y1 As Long
     Dim iLen As Long, iPos As Long
     Dim SB As String, ST As String
     Dim sOut As String
     Dim Offset As Long, sOffset As String
      
     iLen = Len(sIn)
     
     If iLen = 0 Then Exit Function
     
     sOut = ""
     Offset = 0
     
     For X1 = 0 To ((iLen - 1) \ 16)
         
         sOffset = Right$("0000" & Hex(Offset), 4)
         SB = String(48, " ")
         ST = "................"
         
         For Y1 = 1 To 16
             iPos = 16 * X1 + Y1
             
             If iPos > iLen Then Exit For
             
             Mid(SB, 3 * (Y1 - 1) + 1, 2) = Right("00" & Hex(Asc(Mid(sIn, iPos, 1))), 2) & " "
             
             Select Case Asc(Mid(sIn, iPos, 1))
                Case 0, 9, 10, 13
                Case Else
                    Mid(ST, Y1, 1) = Mid(sIn, iPos, 1)
             End Select
         Next Y1
         
         If Len(sOut) > 0 Then sOut = sOut & vbNewLine
         
         sOut = sOut & sOffset & ":  "
         sOut = sOut & SB & "  " & ST
         Offset = Offset + 16
         
     Next X1
     
     DebugOutput = sOut

 End Function

Public Function GetHash(Product As String, MPQFileN As String, ByRef Hashes() As String)

Select Case Product
    Case "RATS", "PXES"
        Hashes(0) = Settings.star_path & "StarCraft.exe"
        Hashes(1) = Settings.star_path & "storm.dll"
        Hashes(2) = Settings.star_path & "Battle.snp"
        Hashes(4) = Settings.star_path & "STAR.bin"
    Case "NB2W"
        Hashes(0) = Settings.w2bn_path & "Warcraft II BNE.exe"
        Hashes(1) = Settings.w2bn_path & "storm.dll"
        Hashes(2) = Settings.w2bn_path & "Battle.snp"
        Hashes(4) = Settings.w2bn_path & "W2BN.bin"
    Case "3RAW", "PX3W"
        Hashes(0) = Settings.war3_path & "war3.exe"
        Hashes(1) = Settings.war3_path & "storm.dll"
        Hashes(2) = Settings.war3_path & "game.dll"
    Case "VD2D"
        Hashes(0) = Settings.d2dv_path & "Game.exe"
        Hashes(1) = Settings.d2dv_path & "Bnclient.dll"
        Hashes(2) = Settings.d2dv_path & "D2client.dll"
End Select


If LenB(MPQFileN) <> 0 Then Hashes(3) = Settings.lockdown_path & Left(MPQFileN, Len(MPQFileN) - 4) & ".dll"

End Function

Public Function P_split(sIP As String) As String
Dim splt() As String, i As Byte

  splt = Split(sIP, ".")
  For i = 0 To UBound(splt)
    P_split = P_split & Chr$(CStr(splt(i)))
  Next i

End Function

Public Function Gateway(Server As String) As String
Dim spltsrv() As String

spltsrv = Split(Server, ".")

If IsNumeric(spltsrv(1)) Then
    Select Case CInt(spltsrv(1))
        Case 240:         Gateway = "USEast Azeroth"
        Case 241:         Gateway = "USWest Lordaeron"
        Case 248:         Gateway = "Europe Northrend"
        Case 233:         Gateway = "Asia Kalimdor"
    End Select
Else
    Select Case LCase$(spltsrv(0))
        Case "useast":    Gateway = "USEast Azeroth"
        Case "uswest":    Gateway = "USWest Lordaeron"
        Case "europe":    Gateway = "Europe Northrend"
        Case "asia":      Gateway = "Asia Kalimdor"
    End Select
End If

End Function

Public Function Pad_Tag(ByVal ClanTag As String) As String
ClanTag = Trim(StrReverse(ClanTag))
Dim FixedTag As String * 4
   
If Len(ClanTag) = 1 Then ClanTag = Chr(0) & ClanTag
If Len(ClanTag) = 2 Then ClanTag = Chr(0) & ClanTag
If Len(ClanTag) = 3 Then ClanTag = Chr(0) & ClanTag
FixedTag = ClanTag
Pad_Tag = FixedTag
End Function

Public Function UnPad_Tag(ByVal ClanTag As String) As String
UnPad_Tag = Replace(ClanTag, Chr(0), vbNullString)
End Function

Public Function GetRank(Rank As Byte) As String
Select Case Rank
    Case &H0: GetRank = "Initiate"
    Case &H1: GetRank = "Peon"
    Case &H2: GetRank = "Grunt"
    Case &H3: GetRank = "Shaman"
    Case &H4: GetRank = "Chieften"
End Select
End Function

Public Function get_verbyte(Product As String) As Byte
Dim Hashes(4) As String: Call GetHash(Product, vbNullString, Hashes())

get_verbyte = bnlib_get_hashbyte(Hashes(0))
End Function

Public Function get_bnlibversion() As String
Dim Version As String: Version = Space$(10)
Call Hash_Lib.bnlib_version(Version)

get_bnlibversion = Left(Version, InStr(Version, vbNullChar))
End Function
